﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

#if UNITY_EDITOR
using UnityEditor;

namespace EditorGame {
	public class EditorCoroutine {

		public static EditorCoroutine start(IEnumerator _routine)
		{
			EditorCoroutine coroutine = new EditorCoroutine(_routine);
			coroutine.start();

			return coroutine;
		}

		readonly IEnumerator routine;
		EditorCoroutine(IEnumerator _routine)
		{
			routine = _routine;
		}

		void start()
		{
			EditorApplication.update += update;
		}

		void stop()
		{
			EditorApplication.update -= update;
		}

		void update()
		{
			if (!routine.MoveNext()) {
				stop();
			}
		}
	}
}
#endif // UNITY_EDITOR
